MObject->Fields (
  priv_watcher    => {default => 0, requires => [qw(priv_runner)]},
  priv_builder    => {default => 0, requires => [qw(priv_runner)]},
  priv_runner     => {default => 0, requires => [qw(priv_controller)]},
  priv_controller => {default => 0, requires => [qw(priv_controller)]},
);

MObject->Commands (
#---------------------------------------------------------------------------------------------------
'goto' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;
    my $dest;
    my $silent = $args =~ s/\s*(-s)\s*//;
    
    my $obj = $self->object_find($args, entire_world => 1);
    $dest = $obj->container || $obj;

    my $c = $dest;
    while ($c) {
      if ($c == $self) {
        $self->send('That would put you inside yourself.');
        return;
      }
      $c = $c->container;
    }

    if ($dest) {
      $self->nact('<self?The world:<self>> disappears in <self?whiteness:a puff of smoke>.');
      $self->move_into($dest);
      $self->nact('<self> appear<self!s> with a <self!n ear-splitting >bang.') unless $silent;
    }
  },
},
#---------------------------------------------------------------------------------------------------
'transfer' => {
  requires => [qw(runner)],
  code => sub {
    my ($self, $args) = @_;
    $args or do {
      $self->send("Transfer what??");
      return;
    };
    my $obj = $self->object_find($args, entire_world => 1);

    my $destination = $self->container;
    while ($destination->glance_contents) {
      $destination = $destination->container;
    }

    my $c = $destination;
    while ($c) {
      if ($c == $obj) {
        $self->send('That would put it inside itself.');
        return;
      }
      $c = $c->container;
    }

    if ($obj) {
      $obj->nact('<self?The world:<self>> disappears in <self?whiteness:a puff of smoke>.');
      $obj->move_into($destination);
      $obj->nact('<self!<self> appears with an ear-splitting bang.>');
    }
  },
},
#---------------------------------------------------------------------------------------------------
new => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $args) = @_;
    if (!$args) {
      $self->add_contents(MObject->new);
      $self->send("Empty object created.");
    } elsif (MIndex->get("proto.$args")) {
      $self->add_contents(my $obj = new MObject('prototype' => $args));
      $self->nact('<self> make<self!s> <self?the appropriate:a peculiar> gesture and <obj> appears in <self.genderp> hand.', obj => $obj);
    } else {
      $self->send('That prototype does not exist.');
    }
  },
  help => <<'EOHELP',
new [&g;<prototype>&n;]

Creates an object in your inventory, optionally with a prototype.

Example:
 > new species.horse
 You create a horse.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'destroy' => {
  requires => [qw(builder)],
  code => sub {
    my ($self, $args) = @_;
    if (!$args) {
      $self->send("Destroy what?");
      return;
    } elsif ('inventory' =~ /^$args/i) {
      foreach (@{$self->contents}) {
        $_->dispose;
      }
      $self->send('Inventory destroyed.');
    } else {
      foreach my $obj ($self->object_find($args, entire_world => 1)) {
        $obj->nact('<self> suddenly explode<self!s> in flames and burn<self!s> to a crisp.');
        $obj->dispose;
      }
    }
  },
  help => <<'EOHELP',
destroy &g;<thing>&n;

Destroys the object(s) specified, leaving a pile of ashes.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'shutdown' => {
  requires => [qw(controller)],
  code => sub {
    my ($self, $args) = @_;

    mudlog "(PC) Shutdown by " . $self->name;
    $::Quit = 'normal';
  },
},
#---------------------------------------------------------------------------------------------------
'reboot' => {
  requires => [qw(controller)],
  code => sub {
    my ($self, $args) = @_;

    mudlog "(PC) Reboot by " . $self->name;
    $::Quit = 'restart';
  },
},
#---------------------------------------------------------------------------------------------------
'eval' => {
  requires => [qw(controller)],
  code => sub {
    my ($self, $args) = @_;
    my $result = eval $args;
    $self->send((defined $result ? $result : 'undef'), $@ || '');
  },
  help => <<'EOHELP',
Evaluates its argument as Perl code.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'call' => {
  requires => [qw(controller)],
  code => sub {
    my ($self, $args) = @_;
    
    $args =~ s/^\((.*?)\)\s+// or $args =~ s/^(\S+)\s+// or die "CFAIL:No object specified!";
    my $obj = $self->object_find($1);
    my $meth = $args;
    my $code = '$obj->' . $args;
    #$self->send($code);
    my $result = eval $code;
    $self->send($@ || '' . (defined $result ? $result : 'undef'));
  },
  help => <<'EOHELP',
call &:g;<target> <meth>&:n;

Looks for the object named <target> and executes the Perl code "$obj->&:g;<meth>&:n;".

Example:
  > call chair nphr(2)
  2 chairs
EOHELP
},
#---------------------------------------------------------------------------------------------------
'disconnect' => {
  requires => [qw(runner)],
  code => sub {
    my ($self, $args) = @_;
    my $con = MConnection->by_id($args) or do {
      $self->send("There is no connection with ID $args.");
      return;
    };
    mudlog "(PC) @{[$self->name]} disconnected connection $args (".$con->login_name.")";
    $con->disconnect;
  },
},
#---------------------------------------------------------------------------------------------------
'dump' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;

    my $obj = $self->object_find($args, entire_world => 1);
    
    use Data::Dumper;
    local $Data::Dumper::Indent = 2;
    $self->send(Dumper($obj->clone_for_freeze));
  },
},
#---------------------------------------------------------------------------------------------------
  force => {
    requires => [qw(runner)],
    code => sub {
      my ($self, $args) = @_;
if ($args) {
  (my $view) = $args =~ s/-f\s+//i;
  my ($target, $str) = split /\s+/, $args, 2;
  if (my $obj = $self->object_find($target, entire_world => 1)) {
    if ($obj->priv_watcher and !$self->priv_controller) { # FIXME: need better [forcing someone with more privs than you] protection
      $self->send('Force someone your own size.');
      return;
    }
    $str ||= '';
    
    $self->nact("<self> force<self!s> <obj> to '$str'.", obj => $obj);
    mudlog '(PC) ' . $self->name . ' forces ' . $obj->name . " to $str";

    if ($view) {
      local $obj->{connection} = $self->connection;
      local $self->{connection};
      $obj->do($str);
      $self->send('~~');
    } else {
      $obj->do($str);
    }
  } else {
    $self->send("You don't see a $target.\n");
  }
} else {
  $self->send('Force what??');
}
    },
  },
#---------------------------------------------------------------------------------------------------
#'connections' => {
#  requires => [qw(watcher)],
#  code => sub {
#    my ($self, $args) = @_;
#    my $fmt = "%3s %-21s %-15s %-25s %-12s";
#    $self->send(sprintf($fmt,
#      qw(ID Source LoginName Object State),
#    ));
#   
#    $self->send("--- --------------------- --------------- ------------------------- ------------");
#
#    foreach (MConnection->all) {
#      my $po = $_->object;
#
#      $self->send(sprintf($fmt,
#        $_->id, $_->source, $_->login_name || 'n/a', $po ? $po->nphr.'#'.$po->id : 'n/a', $_->state,
#      ));
#    }
#  },
#},
#---------------------------------------------------------------------------------------------------
'connections' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;
    
    my @names = qw(ID Source LoginName Object State);
    my @data = ();
    my @max = (0) x 5;

    foreach (MConnection->all) {
      my $po = $_->object;
      my $s;

      push @data, [
        ($s = $_->id,                              $max[0] = max($max[0], length $s), $s),
        ($s = $_->source,                          $max[1] = max($max[1], length $s), $s),
        ($s = $_->login_name || 'n/a',             $max[2] = max($max[2], length $s), $s),
        ($s = $po ? $po->nphr.'#'.$po->id : 'n/a', $max[3] = max($max[3], length $s), $s),
        ($s = $_->state,                           $max[4] = max($max[4], length $s), $s),
      ];
    }
    foreach (@max) { $_++ }
    
    my $fmt = (join ' ', map {"%${_}s"} @max) . "\n";
    my @buf = sprintf($fmt, @names);
    push @buf, join ' ', map {'-' x $_} @max;
    foreach (@data) {
      push @buf, sprintf($fmt, @$_);
    }

    $self->send_multicol(@buf);
  },
},
#---------------------------------------------------------------------------------------------------
'scheduler' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;
    if ($args =~ /^stop ("|'|)(\d+)\1$/i) {
      if (!$self->CONTROLLER or MScheduler->task_owner($2) ne $self->id) {
        die "CFAIL:You do not have permission to remove that task.";
      }
      MScheduler->remove_task($2);
      $self->send("Task '$2' removed.");
    } else {
      $self->send_multicol(MScheduler->report);
    }
  },
  help => <<'EOHELP',
Displays the current status of the scheduler. The "Owner" column is the ID of the object that owns the task, if any.

If there are many tasks with negative "Runs-In" values, then the MUD is overloaded.
EOHELP
},
#---------------------------------------------------------------------------------------------------
#'grep' => {
#  requires => [qw(watcher)],
#  code => sub {
#    use Data::Dumper ();
#    my ($self, $args) = @_;
#    my $pat = $args;
#    my $found;
#    MObject->all_do(sub {
#      my ($obj) = @_;
#      foreach (keys %$obj) {
#        next unless $_ =~ /$pat/ or Data::Dumper::Dumper($obj->{$_}) =~ /$pat/;
#        $self->send("Object #@{[$obj->id]} (@{[$obj->name]})");
#        return;
#      }
#    });
#    MObject->all_proto_do(sub {
#      my ($name, $obj) = @_;
#      foreach (keys %$obj) {
#        next unless $name =~ /$pat/ or $_ =~ /$pat/ or Data::Dumper::Dumper($obj->{$_}) =~ /$pat/;
#        $self->send("Prototype $name (@{[$obj->name]})");
#        return;
#      }
#    });
#  },
#  help => <<'EOHELP',
#The &c;grep&n; command searches all objects and object prototypes for the given regular expression. One should be careful with this command, as the wrong regexp can cause it to return every single object and prototype in the world; while this would not be a serious problem, it would likely tie up your terminal for a significant amount of time.
#EOHELP
#},
#---------------------------------------------------------------------------------------------------
'sysinfo' => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;
    my ($buf, $t) = ('');

    $buf .= "mpMUD running on Perl $] on '$^O'.\n";
    $buf .= "This MUD is called '$::Config{'name'}'.\n";
    $buf .= "$t is being used for storing structures.\n" if $t = $MFreezer::USE;
    $buf .= "$t scheduled tasks.\n" if $t = scalar @MScheduler::Tasks;
    $buf .= "$t scheduled events.\n" if $t = scalar @MScheduler::Events;
    $buf .= "$t objects in memory.\n" if $t = scalar keys %MObjectDB::ObjCache;
    $buf .= "$t stale objects leaked.\n" if $t = scalar keys %MObject::StaleObjects;
    $buf .= sprintf("Main loop speed: %.2f iters/sec\n", $t) if $t = MScheduler->performance;
    $buf .= "Current time: $t\n" if $t = format_time(MScheduler->mudclock());
    
    $self->send_page($buf);
  },
  help => <<'EOHELP',
Displays various status information.
EOHELP
},
#---------------------------------------------------------------------------------------------------
mkobs => {
  requires => [qw(watcher)],
  code => sub {
    my ($self, $args) = @_;

    use MConnection::Capturing;
    my $obj = $self->object_find($args);
    my $con = MConnection::Capturing->new;
    $con->link_to_object($obj);
    $self->send(ucfirst $obj->nphr . " is now an observer.");
  },
  help => <<'EOHELP',
Creates a 'capturing' connection and attaches it to the object specified, so that it logs all text sent to it.

This can not currently be used on players.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'switch' => {
  requires => [qw(runner)],
  code => sub {
    my ($self, $args) = @_;

    my $obj = $self->object_find($args);
    $self->connection->link_to_object($obj);
    $obj->do('look');
  },
  help => <<'EOHELP',
Links your connection to a different object.
EOHELP
},
#---------------------------------------------------------------------------------------------------
'return' => {
  requires => [qw()],
  code => sub {
    my ($self, $args) = @_;

    my $obj = MObjectDB->get($self->connection->pref('object'));
    $self->connection->link_to_object($obj);
    $obj->do('look');
  },
  help => <<'EOHELP',
Links your connection to your normal body.
EOHELP
},
#---------------------------------------------------------------------------------------------------
);

MObject->CommandAliases(
  destroy => [qw(purge)],
  new => [qw(load oload)],
  disconnect => [qw(dc)],
  connections => [qw(users)],
);
